#include <Wire.h>
#define DS3231_adresa 0x68  //I2C adresa DS3231

// konverze BCD do dekadického čísla
byte BCDdoDEC(byte val){
    return( (val/16*10) + (val%16) );
}

void setup()
  {
    Wire.begin();
    Serial.begin(9600);
  }

void cteniDS3231casu(byte *sekundy, byte *minuty, byte *hodiny, byte *denVt, byte *den, byte *mesic, byte *rok)
  {
    Wire.beginTransmission(DS3231_adresa);
    Wire.write(0);                         //nastavení ukazatele registrů v DS3231 na 00h
    Wire.endTransmission();
    Wire.requestFrom(DS3231_adresa, 7);    //čtení 7 bytů z DS3231
    //čtení 7 bytů dat z DS3231 od registru 00h
    *sekundy = BCDdoDEC(Wire.read() & 0x7f);
    *minuty = BCDdoDEC(Wire.read());
    *hodiny = BCDdoDEC(Wire.read() & 0x3f);
    *denVt = BCDdoDEC(Wire.read());
    *den = BCDdoDEC(Wire.read());
    *mesic = BCDdoDEC(Wire.read());
    *rok = BCDdoDEC(Wire.read());
  }

void loop()
  {
    byte sekundy, minuty, hodiny, denVt, den, mesic, rok; //proměnné
    cteniDS3231casu(&sekundy, &minuty, &hodiny, &denVt, &den, &mesic, &rok); //čtení času

    Serial.print(hodiny, DEC);
    Serial.print(":");
    Serial.print(minuty, DEC);
    Serial.print(":");
    if (sekundy<10)
      {
        Serial.print("0");
      }
    Serial.print(sekundy, DEC);
    Serial.print(" den:");
    Serial.print(denVt, DEC);
    Serial.print(" ");
    Serial.print(den,DEC);
    Serial.print(".");
    Serial.print(mesic, DEC);
    Serial.print(".20");
    Serial.println(rok, DEC);
    delay(1000);
  }
