#include "Wire.h"
#define DS3231_adresa 0x68  //I2C adresa DS3231

// konverze desítkového čísla do BCD
byte DECdoBCD(byte val){
    return( (val/10*16) + (val%10) );
  }
void setup()
  {
    Wire.begin();
    // Nastavení hodin
    // DS3231 (sekundy, minuty, hodiny, den v týdnu, datum, měsíc, rok)
    nastaveniDS3231(00,29,13,6,8,10,22);  //tady se nastaví aktuální hodnoty podle klíče výše
  }

void nastaveniDS3231(byte sekundy, byte minuty, byte hodiny, byte denVt, byte den, byte mesic, byte rok)
  {
    // odeslání dat do DS3231
    Wire.beginTransmission(DS3231_adresa);
    Wire.write(0);                   // nastavení
    Wire.write(DECdoBCD(sekundy));   // nastavení sekund
    Wire.write(DECdoBCD(minuty));    // nastavení minut
    Wire.write(DECdoBCD(hodiny));    // nastavení hodin
    Wire.write(DECdoBCD(denVt));     // nastavení dne v týdnu (1=sobota, 7=neděle)
    Wire.write(DECdoBCD(den));       // nastavení data
    Wire.write(DECdoBCD(mesic));     // nastavení měsíce
    Wire.write(DECdoBCD(rok));       // nastavení roku (0 to 99)
    Wire.endTransmission();
  }

void loop()
  {
  }
