#include <Wire.h>                 //knihovna pro I2C
#include <DFRobot_MAX17043.h>     //knihovna pro měřič baterky
#include <OneWire.h>              //knihovna pro 1-wire
#include <DallasTemperature.h>    //knihovna pro DS18B20
#include <Adafruit_INA219.h>      //knihovna pro čidlo proudu
#include <avr/power.h>            //knihovna pro zapínání/vypínání periferií


#define TX_PIN 9        //Tx pin
#define LED A3          //LED na pin A3
#define TEMP 6          //napájení DS18B20 na pinu 6
#define ESP 7           //vypínání  na pin 7
#define ONE_WIRE_BUS 8  //1-wire na pin 8

#define ADDR 0x40       //adresa čidla proudu
#define DOT_TIME 50     //délka tečky morseovky v milisekundách
#define TONE_FREQ 700   //frekvence tónu morseovky v Hz

int BATproc = 0;        //proměnná pro stav baterky %
float teplota = 0;      //proměnná pro teplotu
float proud = 0;        //proměnná proudu z panelu
float napeti = 0;       //proměnná napětí baterky

OneWire oneWire(ONE_WIRE_BUS);

Adafruit_INA219 ina219(ADDR); //nastavení INA219
DFRobot_MAX17043 gauge;       //inicializace měřiče baterky
DallasTemperature sensors(&oneWire);

void setup() 
{
  pinMode(TX_PIN, OUTPUT);    //Tx pin výstupní
  pinMode(LED, OUTPUT);       //LED pin výstupní
  pinMode(ESP, OUTPUT);       //ESP pin výstupní
  pinMode(TEMP, OUTPUT);      //TEMP pin výstupní
  pinMode(10,INPUT_PULLUP);   //nevyužitý pin jako vstup s pullupem
  pinMode(2,INPUT_PULLUP);    //nevyužitý pin jako vstup s pullupem
  pinMode(3,INPUT_PULLUP);    //nevyužitý pin jako vstup s pullupem
  pinMode(4,INPUT_PULLUP);    //nevyužitý pin jako vstup s pullupem
  pinMode(5,INPUT_PULLUP);    //nevyužitý pin jako vstup s pullupem
  pinMode(11,INPUT_PULLUP);   //nevyužitý pin jako vstup s pullupem
  pinMode(12,INPUT_PULLUP);   //nevyužitý pin jako vstup s pullupem
  pinMode(13,INPUT_PULLUP);   //nevyužitý pin jako vstup s pullupem
  pinMode(A0,INPUT_PULLUP);   //nevyužitý pin jako vstup s pullupem
  pinMode(A1,INPUT_PULLUP);   //nevyužitý pin jako vstup s pullupem
  pinMode(A2,INPUT_PULLUP);   //nevyužitý pin jako vstup s pullupem 
  digitalWrite(TX_PIN, LOW);  //Tx vypni
  digitalWrite(LED, LOW);     //LED zhasni
  digitalWrite(ESP, LOW);     //ESP vypni
  digitalWrite(TEMP, LOW);    //TEMP vypni
  Wire.begin();               //start I2C
  sensors.begin();
  ina219.begin();                   //inicializace čidla proudu
  ina219.setCalibration_32V_1A();   //nastavení čidla proudu

  power_spi_disable();        //vypnout SPI
  ACSR |= (1 << ACD);         //vypnout komparátor


  digitalWrite(LED, HIGH);          //rozsviť LED
  delay(1000);                      //čekej 1s
  digitalWrite(LED, LOW);           //zhasni LED
  clock_prescale_set(clock_div_1);  //taktujeme na 8MHz
}

void loop() 
{
  BATproc = gauge.readPercentage();     //načti stav baterie v %
  proud = ina219.getCurrent_mA();       //načti proud z panelu
  digitalWrite(TEMP, HIGH);             //zapni čidlo teploty
  delay(1000);                          //chvilku počkej
  sensors.begin();                      //inicializace 1-wire
  delay(500);                           //chvilku počkej
  sensors.requestTemperatures();        //inicializace čidla teploty
  teplota = sensors.getTempCByIndex(0); //načtení teploty
  delay(500);                           //chvilku počkej
  digitalWrite(TEMP, LOW);              //vypni čidlo teploty

 
  RFmorse();  //vysílej morseovku

  if(BATproc >= 30)   //pokud je stav baterky více než 30% zapni příslušenství
    {
      digitalWrite(ESP, HIGH);            //zapni ESP
      digitalWrite(LED, HIGH);            //rozsviť LED
      delay(1000);                        //čekej 1s na start ESP modulu

      for(int i = 0; i < 150; i++)      //čekej 30 sekund a přitom blikej LED
        {
          digitalWrite(LED, HIGH);      //zapni LED
          delay(100);                   //čekej
          digitalWrite(LED, LOW);       //zhasni LED
          delay(100);                   //čekej
        }

      digitalWrite(ESP, LOW);   //vypni wifi
      digitalWrite(LED, LOW);   //zhasni LED
    }

    if(BATproc > 80)        //pokud je stav baterky více než 80%
      {
        clock_prescale_set(clock_div_64); //podtaktujeme na 125kHz
        delay(4687);                      //čekej 5 minut
        clock_prescale_set(clock_div_1);  //taktujeme na 8MHz
      }
      else if(BATproc > 50) //pokud je stav baterky více než 50%
      {
        clock_prescale_set(clock_div_64); //podtaktujeme na 125kHz
        delay(9375);                      //čekej 10 minut
        clock_prescale_set(clock_div_1);  //taktujeme na 8MHz
      }
      else if(BATproc > 20) //pokud je stav baterky více než 20%
      {
        clock_prescale_set(clock_div_64); //podtaktujeme na 125kHz
        delay(18750);                     //čekej 20 minut
        clock_prescale_set(clock_div_1);  //taktujeme na 8MHz
      }
      else if(BATproc > 10) //pokud je stav baterky více než 10%
      {
        clock_prescale_set(clock_div_64); //podtaktujeme na 125kHz
        delay(28125);                     //čekej 30 minut
        clock_prescale_set(clock_div_1);  //taktujeme na 8MHz
      }
      else                  //jinak
      {
        clock_prescale_set(clock_div_64); //podtaktujeme na 125kHz
        delay(56250);                     //čekej 1 hodinu
        clock_prescale_set(clock_div_1);  //taktujeme na 8MHz
      }
}  

//////////////////////////////////////////////////vysílání RF//////////////////////////////////////////////////////
void RFmorse()
{
  String zprava = "CQ CQ CQ NEDSAT: BATERKA=" + String(BATproc) + "procent, PROUD=" + String(proud) + "mA, TEPLOTA=" + String(teplota, 2) + "stupnu WWW.ARZE.CZ";

  sendMorse(zprava);
}

// ---------- Generování Morseovky ----------
void sendMorse(String message) 
{
  for (int i = 0; i < message.length(); i++) 
  {
    char c = toupper(message[i]);

    if (c == ' ') 
    {
      delay(DOT_TIME * 7); // mezera mezi slovy
    } 
    else 
    {
      sendChar(c);
      delay(DOT_TIME); // mezera mezi písmeny
    }
  }
}

void sendChar(char c) 
{
  String morse;
  switch (c) {
    case 'A': morse = ".-"; break;
    case 'B': morse = "-..."; break;
    case 'C': morse = "-.-."; break;
    case 'D': morse = "-.."; break;
    case 'E': morse = "."; break;
    case 'F': morse = "..-."; break;
    case 'G': morse = "--."; break;
    case 'H': morse = "...."; break;
    case 'I': morse = ".."; break;
    case 'J': morse = ".---"; break;
    case 'K': morse = "-.-"; break;
    case 'L': morse = ".-.."; break;
    case 'M': morse = "--"; break;
    case 'N': morse = "-."; break;
    case 'O': morse = "---"; break;
    case 'P': morse = ".--."; break;
    case 'Q': morse = "--.-"; break;
    case 'R': morse = ".-."; break;
    case 'S': morse = "..."; break;
    case 'T': morse = "-"; break;
    case 'U': morse = "..-"; break;
    case 'V': morse = "...-"; break;
    case 'W': morse = ".--"; break;
    case 'X': morse = "-..-"; break;
    case 'Y': morse = "-.--"; break;
    case 'Z': morse = "--.."; break;
    case '0': morse = "-----"; break;
    case '1': morse = ".----"; break;
    case '2': morse = "..---"; break;
    case '3': morse = "...--"; break;
    case '4': morse = "....-"; break;
    case '5': morse = "....."; break;
    case '6': morse = "-...."; break;
    case '7': morse = "--..."; break;
    case '8': morse = "---.."; break;
    case '9': morse = "----."; break;
    case '.': morse = ".-.-.-"; break;
    case '=': morse = "-...-"; break;
    case '-': morse = "-....-"; break;
    default: return; // nepodporovaný znak
  }

  for (int j = 0; j < morse.length(); j++) 
  {
    if (morse[j] == '.') 
    {
      dot();
    } 
    else if (morse[j] == '-') 
    {
      dash();
    }
  }
}

void dot()                    //vysílání tečky
{
  tone(TX_PIN, TONE_FREQ);    //vysílej tón
  delay(DOT_TIME);            //čekej
  noTone(TX_PIN);             //nevysílej tón
  delay(DOT_TIME);            //mezera za tečkou
}

void dash()                   //vysílání čárky
{
  tone(TX_PIN, TONE_FREQ);    //vysílej tón
  delay(DOT_TIME * 3);        //čekej
  noTone(TX_PIN);             //nevysílej tón
  delay(DOT_TIME);            //mezera za čárkou
}