#include <Wire.h>
#include <Adafruit_BME280.h>
#include <ESP8266WiFi.h>
#include <ESP8266HTTPClient.h>

const char* ssid = "název wifi";
const char* password = "heslo k wifi";

// BME280 nastavení
#define SEALEVELPRESSURE_HPA 1013.25
Adafruit_BME280 bme;

// WiFi klient
WiFiClient client;

void setup() 
{
  // Připojení k WiFi
  WiFi.begin(ssid, password);
  while(WiFi.status() != WL_CONNECTED) 
  {
    delay(500);
  }

  // Inicializace BME280
  if(!bme.begin(0x76)) 
  {
    while (1);
  }

  delay(2000); // Stabilizace čidla

  // Načtení hodnot
  float teplota = bme.readTemperature();
  float tlak = bme.readPressure() / 100.0F; // hPa
  float vlhkost = bme.readHumidity();

  // Odeslání dat na NAS
  if(WiFi.status() == WL_CONNECTED) 
  {
    HTTPClient http;

    // Připrav URL
    String url = "http://adresa webu/pridej.php?teplota=" + String(teplota, 2) +
                 "&vlhkost=" + String(vlhkost, 2) +
                 "&tlak=" + String(tlak, 2);

    http.begin(client, url);
    int httpCode = http.GET();
    if (httpCode > 0) 
    {
      String payload = http.getString();
    } 
    else 
    {

    }
    http.end();
  } 
  else
   {

  }
}

void loop() 
{
  // Nic, čekáme na vypnutí
}