<?php
// ======= CSV NAČÍTÁNÍ SE STŘEDNÍKEM =======
$data = [];
if (($handle = fopen("data.csv", "r")) !== FALSE) {
    $hlavicka = fgetcsv($handle, 1000, ";");
    while (($row = fgetcsv($handle, 1000, ";")) !== FALSE) {
        $data[] = $row;
    }
    fclose($handle);
}

// ======= PŘÍPRAVA POLÍ =======
$cas = [];
$teploty = [];
$vlhkosti = [];
$tlaky = [];

foreach ($data as $radek) {
    $cas[] = trim(str_replace('"','',$radek[0]));
    $teploty[] = (float) $radek[1];
    $vlhkosti[] = (float) $radek[2];
    $tlaky[] = (float) $radek[3];
}

// ======= MIN/MAX TEPLOTY PODLE DNŮ =======
$teploty_tab = [];
foreach ($data as $radek) {
    $datum = substr(trim($radek[0]), 0, 10);
    $teplota = (float) $radek[1];

    if (!isset($teploty_tab[$datum])) {
        $teploty_tab[$datum] = ['min' => $teplota, 'max' => $teplota];
    } else {
        if ($teplota < $teploty_tab[$datum]['min']) $teploty_tab[$datum]['min'] = $teplota;
        if ($teplota > $teploty_tab[$datum]['max']) $teploty_tab[$datum]['max'] = $teplota;
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Přehled dat</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>
    <style>
        body { font-family: Arial, sans-serif; }
        .grafy {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
        }
        .graf, .tabulka {
            flex: 1 1 45%;
            min-width: 300px;
        }
        canvas { 
            width: 100%; 
            height: 200px;
        }
        table { 
            border-collapse: collapse; 
            width: 100%;
        }
        th, td { 
            border: 1px solid black; 
            padding: 5px; 
            text-align: center;
        }
    </style>
</head>
<body>
    <h1>Přehled dat</h1>

    <div class="grafy">
        <div class="graf">
            <h2>Graf teploty</h2>
            <canvas id="grafTeplota"></canvas>
        </div>
        <div class="graf">
            <h2>Graf vlhkosti</h2>
            <canvas id="grafVlhkost"></canvas>
        </div>
    </div>

    <div class="grafy">
        <div class="graf">
            <h2>Graf tlaku</h2>
            <canvas id="grafTlak"></canvas>
        </div>
        <div class="tabulka">
            <h2>Minimální a maximální teploty podle dnů</h2>
            <table>
                <tr><th>Datum</th><th>Min teplota (°C)</th><th>Max teplota (°C)</th></tr>
                <?php foreach ($teploty_tab as $datum => $temp): ?>
                    <tr>
                        <td><?= htmlspecialchars($datum) ?></td>
                        <td><?= htmlspecialchars(number_format($temp['min'], 2)) ?></td>
                        <td><?= htmlspecialchars(number_format($temp['max'], 2)) ?></td>
                    </tr>
                <?php endforeach; ?>
            </table>
        </div>
    </div>

<script>
const casy = <?= json_encode($cas) ?>;
const teploty = <?= json_encode($teploty) ?>;
const vlhkosti = <?= json_encode($vlhkosti) ?>;
const tlaky = <?= json_encode($tlaky) ?>;

function vytvorGraf(canvasId, label, data, barva, yText) {
    new Chart(document.getElementById(canvasId), {
        type: 'line',
        data: {
            labels: casy,
            datasets: [{
                label: label,
                data: data,
                borderColor: barva,
                borderWidth: 3,
                pointRadius: 6,
                pointBackgroundColor: 'blue',
                fill: false
            }]
        },
        options: {
            scales: {
                x: {
                    title: {
                        display: true,
                        text: 'Čas'
                    }
                },
                y: {
                    beginAtZero: false,
                    title: {
                        display: true,
                        text: yText
                    }
                }
            }
        }
    });
}

vytvorGraf('grafTeplota', 'Teplota (°C)', teploty, 'red', 'Teplota (°C)');
vytvorGraf('grafVlhkost', 'Vlhkost (%)', vlhkosti, 'blue', 'Vlhkost (%)');
vytvorGraf('grafTlak', 'Tlak (hPa)', tlaky, 'green', 'Tlak (hPa)');
</script>
</body>
</html>
