#include <LiquidCrystal.h>

#define startTL 10   //pin 10
#define rele 13    //pin 13
#define prepinac 8 //pin 8

long casSTART = 0;
int citac = 0; 
int KONEC = 0;

long h2h = 7200000;    //počet ms ve 2h
long h12h = 43200000;  //počet ms ve 12h

unsigned long ZBYVAms = 0;     //zbývající čas v ms
unsigned long STOPms = 0;      //vypínací čas
unsigned long ZBYVAh = 1;      //zbývající čas v hodinách
unsigned long ZBYVAm = 1;      //zbývající čas v minutách
unsigned long ZBYVAs = 1;      //zbývající čas v sekundách



LiquidCrystal lcd(7, 6, 5, 4, 3, 2);   //zapojení LCD

// konverze BCD do dekadického čísla
byte BCDdoDEC(byte val){
    return( (val/16*10) + (val%16) );
}

//vytvoření znaku "ý"
byte ypsilon[8] = {
  B00010,
  B00100,
  B10001,
  B10001,
  B01111,
  B00001,
  B01110,
  B00000
};

//vytvoření znaku "á"
byte aaa[8] = {
  B00010,
  B00100,
  B01110,
  B00001,
  B01111,
  B10001,
  B01111,
  B00000
};



void setup() 
  {
  lcd.begin(8, 2);  //LCD 16 znaků, 1 řádek - řadič je 8 znaků na 2 řádky

  lcd.createChar(0, ypsilon);  //vytvoření znaku "ý"
  lcd.createChar(1, aaa);      //vytvoření znaku "á"
  
  pinMode(startTL, INPUT);
  pinMode(rele, OUTPUT);
  pinMode(prepinac, INPUT);

  digitalWrite(startTL, HIGH);  //pull-up na vstup start
  digitalWrite(rele, LOW); //zapnout relé
  digitalWrite(prepinac, HIGH); //pull-up na vstup přepínače

  }


void loop()
  {
  lcd.setCursor(0,0);
  lcd.print("Stiskni ");
  lcd.setCursor(0,1);
  lcd.print("start");
  

  if(digitalRead(startTL) == LOW) //při stisknutí start...
    {
     start();        //skoč na start
    }
    
    
    
  if (KONEC == 1) //pokud je čas konce
    {
      digitalWrite(rele, HIGH); //vypnout relé
      
      KONEC = 0;  //vynuluj čas konce
    }
}

void start()
{
    casSTART = millis();
    
  if(digitalRead(prepinac) == LOW) //volba módu
    {
      odpocet12();
    }
    else
    {
      odpocet2();
    }
}

void odpocet2()  //odpočet 2 hodin
  {
    lcd.clear(); //smaž LCD

    STOPms = casSTART + h2h;

    while(ZBYVAm != 0 || ZBYVAh != 0)
     {
      ZBYVAms = STOPms - millis();
      ZBYVAh = ZBYVAms / 3600000;
      ZBYVAm = ZBYVAms % 3600000;
      ZBYVAm = ZBYVAm / 60000;      

      LCDz();       //zobraz na LCD
      delay(1000);  //čekej 1s
     }
   KONEC = 1;
  }

void odpocet12()
  {
    lcd.clear(); //smaž LCD
    
    STOPms = casSTART + h12h;

    while(ZBYVAm != 0 || ZBYVAh != 0)
     {
      ZBYVAms = STOPms - millis();
      ZBYVAh = ZBYVAms / 3600000;
      ZBYVAm = ZBYVAms % 3600000;
      ZBYVAm = ZBYVAm / 60000;   
    
      LCDz();       //zobraz na LCD
      delay(1000);  //čekej 1s
     }
    KONEC = 1;
  }
  

void LCDz()                   //zobrazení na LCD
  {
    lcd.setCursor(0,0);       //nastav 1. půlku
    lcd.print("Zb");          //napiš Zb
    lcd.write(byte(0));       //napiš ý
    lcd.print("v");           //napiš v
    lcd.write(byte(1));       //napiš á
    lcd.print(": ");          //napiš :

    lcd.setCursor(0,1);       //nastav 2.půlku
    
    if (ZBYVAh < 10)       //pokud zbývá méně než 10 hodin
      {
        lcd.print("0");       //napiš 0
      }
    lcd.print(ZBYVAh);     //napiš zbývající hodiny
    
    if (citac == 0)           //pokud je čítač 0
      {
       lcd.print(":");        //napiš :
       citac++;               //přičti čítačí 1
      }
    else                      //pokud je čítač 1
      {
        lcd.print(" ");       //napiš mezeru
        citac = 0;            //vynuluj čítač
      }
      
    if (ZBYVAm < 10)       //pokud zbývá méně než 10 minut
      {
        lcd.print("0");       //napiš 0
      }
    lcd.print(ZBYVAm);     //napiš zbývající minuty

  }
