#include <Rotary.h>
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#define SCREEN_WIDTH 128 //šířka OLED v pixelech
#define SCREEN_HEIGHT 32 //výška OLED v pixelech

#define OLED_RESET     4 // Reset pin # (or -1 if sharing Arduino reset pin)
#define SCREEN_ADDRESS 0x3C //adresa displeje; 0x3D pro 128x64, 0x3C pro 128x32
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET); //inicializace displeje


Rotary r = Rotary(3, 4);            //piny připojení encodéru
volatile int encoderPosCount = 0;   //počítadlo pozice enkodéru

///////////////////zpracování signálu z enkodéru////////////
volatile char result;
volatile bool signal = false;

ISR(PCINT2_vect)
{
  if(signal)
    return;
  result = r.process();
  if (result) {
    if (result == DIR_CCW) encoderPosCount--;
    if (result == DIR_CW) encoderPosCount++;
    signal = true;
  }
}
/////////////////////////////////////////////////////////////


void setup() 
{
  // nastavení přerušení na pinech 3 a 4
  PCMSK2 |= bit (PCINT19); // want pin 3
  PCMSK2 |= bit (PCINT20); // want pin 4
  PCIFR  |= bit (PCIF2);   // clear any outstanding interrupts
  PCICR  |= bit (PCIE2);   // enable pin change interrupts for D0 to D7

  pinMode(13, OUTPUT);      //pin 13 výstup
  digitalWrite(13, LOW);    //pin 13 vypnout

  // SSD1306_SWITCHCAPVCC = interní výroba napětí 3,3V pro displej
  if(!display.begin(SSD1306_SWITCHCAPVCC, SCREEN_ADDRESS)) //spuštění displeje
  {
    for(;;);    //opakuj
  }
  
  display.clearDisplay();             //smaž displej
  display.setTextSize(1);             //velikost textu 1
  display.setTextColor(SSD1306_WHITE);//barva textu bílá
  display.setCursor(0,0);             //pozice textu vlevo nahoře
  display.print("zpozdeni: ");        //text na výpis
  display.print("0");                 //text na výpis
  display.print("ms");                //text na výpis
  display.display();                  //zobraz
}

void loop() 
{
  if (signal)                             //pohyb enkodéru
  {
      if(encoderPosCount <= 0)            //pokud je pozice 0 nebo záporná
        {
          encoderPosCount = 1;            //pak nastav pozici na 1
        }
      display.clearDisplay();             //smaž displej
      display.setTextSize(1);             //velikost textu 1
      display.setTextColor(SSD1306_WHITE);//barva textu bílá
      display.setCursor(0,0);             //pozice textu vlevo nahoře
      display.print("zpozdeni: ");        //text na výpis
      display.print(encoderPosCount);
      display.print("ms");
      display.display();
      signal = false;
   }
  


  digitalWrite(13,HIGH);      //sepni relé
  delay(encoderPosCount);     //čekej podle nastavení enkodéru
  digitalWrite(13,LOW);       //vypni relé
  delay(encoderPosCount);     //čekej podle nastavení enkodéru
}
