#include <Keypad.h>           //knihovna pro klávesnici
#include <Servo.h>            //knihovna pro servo
#include <SoftwareSerial.h>   //knihovna pro softwérový sériový port

#define LEDo 12       //LED otevřeno
#define LEDz 11       //LED zavřeno
#define LEDc 10       //LED čekej
#define LED1 A0       //LED 1.číslo
#define LED2 A1       //LED 2.číslo
#define LED3 A2       //LED 3.číslo
#define LED4 A3       //LED 4.číslo

const byte ROWS = 4;    //4 řádky klávesnice
const byte COLS = 3;    //3 řádky klávesnice

char hexaKeys[ROWS][COLS] = {   //fyzické uspořádání klávesnice
  {'1','2','3'},
  {'4','5','6'},
  {'7','8','9'},
  {'*','0','#'}
};
byte rowPins[ROWS] = {5, 6, 7, 8};  //čísla pinů s připojenými řádky klávesnice
byte colPins[COLS] = {4, 3, 2};  //čísla pinů s připojenými sloupci klávesnice

Keypad customKeypad = Keypad( makeKeymap(hexaKeys), rowPins, colPins, ROWS, COLS);  //nastavení klávesnice

char inKLAVESNICE[] = {'#','#','#','#'};    //proměnná pro načtené klávesy
char heslo[] = {'0','0','0','0'};           //proměnná pro heslo

byte start = 0; //proměnná pro menu

Servo zamek;    //název serva zámek

SoftwareSerial bluetooth(9, A5);

void setup() 
{
  zamek.attach(13);     //servo zámku na pin 13
  bluetooth.begin(9600);   //nastavení sériového portu
  pinMode(LEDo, OUTPUT);//nastavení LED jako výstup
  pinMode(LEDc, OUTPUT);
  pinMode(LEDz, OUTPUT);
  pinMode(LED1, OUTPUT);
  pinMode(LED2, OUTPUT);
  pinMode(LED3, OUTPUT);
  pinMode(LED4, OUTPUT);
  digitalWrite(LED1, LOW);  //zhasni LED
  digitalWrite(LED2, LOW);
  digitalWrite(LED3, LOW);
  digitalWrite(LED4, LOW);
  digitalWrite(LEDo, HIGH); //rozsviť LED
  digitalWrite(LEDc, LOW);
  digitalWrite(LEDz, LOW);
  odemkni();                //odemkni dveře
  start = 100;              //skoč do hlavního menu

}

void loop() 
{
///////////////////////////////////////////////////////Hlavní menu////////////////////////////////////////
  if(start == 100) //volba d hlavní menu
    {
     start = 0;   //vynuluj proměnnou klávesnice
     bluetooth.println();
     bluetooth.println("Hlavni menu");
     bluetooth.println("Zvol si polozku menu:");
     bluetooth.println("a = generuj novy kod");
     bluetooth.println("b = zobraz kod");
     bluetooth.println("c = zamek");
     bluetooth.println("d = Hlavni menu");
     bluetooth.println();

     while(start != 97 && start != 98 && start != 99 && start != 100) //čekej na stisknutí a, b, c, d 
     {
      if(bluetooth.available())      //pokud jsou dostupná data
        {
          start = bluetooth.read();  //načti je do proměnné start
        }
    } 
    }
////////////////////////////////////////////////////////Generování kódu///////////////////////////////////
    else if(start == 97)    //volba "a" - generování kódu
    {
      start = 0;      //vynuluj proměnnou klávesnice
      bluetooth.println("Generuji novy kod");
      bluetooth.print("Novy kod je: ");

      randomSeed(analogRead(A4));
      heslo[0] = random(48,57);     //generuj prvné číslo
      bluetooth.print(heslo[0]);

      delay(100);
      
      randomSeed(analogRead(A6));
      heslo[1] = random(48,57);     //generuj druhé číslo
      bluetooth.print(heslo[1]);

      delay(100);
      
      randomSeed(analogRead(A4));
      heslo[2] = random(48,57);     //generuj třetí číslo
      bluetooth.print(heslo[2]);

      delay(100);
      
      randomSeed(analogRead(A7));
      heslo[3] = random(48,57);     //generuj čtvrté číslo
      bluetooth.println(heslo[3]);
      
      start = 100; //skoč na hlavní menu
      
    }
////////////////////////////////////////////////////////zobraz kód//////////////////////////////////////
    else if(start == 98)    //volba "b" - zobraz kód
    {
      start = 0;      //vynuluj proměnnou klávesnice
      bluetooth.print("Aktualni kod je: ");  //vypiš aktuální heslo
      bluetooth.print(heslo[0]);
      bluetooth.print(heslo[1]);
      bluetooth.print(heslo[2]);
      bluetooth.println(heslo[3]);
      bluetooth.println();

      start = 100;  //skoč na hlavni menu
    }
////////////////////////////////////////////////////////zámek////////////////////////////////////////////
    else if(start == 99)    //volba "c" - zámek
    {
      digitalWrite(LEDz, HIGH); //rozsviť LED zavřeno
      digitalWrite(LEDo, LOW);  //zhasni LED otevřeno
      zamkni();                 //zavři
      bluetooth.println();
      bluetooth.print("Aktualni kod: ");    //vypiš načtený kód
      bluetooth.print(heslo[0]);
      bluetooth.print(heslo[1]);
      bluetooth.print(heslo[2]);
      bluetooth.println(heslo[3]);
      bluetooth.println();
      bluetooth.print("Zadano: ");         //vypisuj zadaný kód
      
      int i=0;
      while(i != 4)
        {
          inKLAVESNICE[i] = customKeypad.getKey();   //načti stisklou klávesu

          //čekej na stisknutí čtyř čísel
          if(inKLAVESNICE[i]==48 || inKLAVESNICE[i] == 49 || inKLAVESNICE[i] == 50 || inKLAVESNICE[i] == 51 || inKLAVESNICE[i] == 52 || inKLAVESNICE[i] == 53 || inKLAVESNICE[i] == 54 || inKLAVESNICE[i] == 55 || inKLAVESNICE[i] == 56 || inKLAVESNICE[i] == 57 )
            {
             bluetooth.print(inKLAVESNICE[i]); //po stisknutí klávesy rozsviť LED
             if(i==0)
              {
              digitalWrite(LED4, HIGH);
              }
              else if(i==1)
              {
              digitalWrite(LED3, HIGH);  
              }
              else if(i==2)
              {
              digitalWrite(LED2, HIGH);  
              }
              else if(i==3)
              {
              digitalWrite(LED1, HIGH);  
              }
              delay(100);                            
             i++; 
            }
        }

        //porovnání zadaného kódu s uloženým
        if(inKLAVESNICE[0] == heslo[0] && inKLAVESNICE[1] == heslo[1] && inKLAVESNICE[2] == heslo[2] && inKLAVESNICE[3] == heslo[3])
          {
            //pokud se shodují
            digitalWrite(LEDz, LOW);    //zhasni LED zavřeno
            digitalWrite(LEDo, HIGH);   //rosviť LED otevřeno
            digitalWrite(LEDc, LOW);    //zhasni LED čekej
            digitalWrite(LED4, LOW);    //zhasni LED tlačítek
            digitalWrite(LED3, LOW);  
            digitalWrite(LED2, LOW);  
            digitalWrite(LED1, LOW); 
            odemkni();                  //odemkni
            bluetooth.println();
            bluetooth.println("OTEVRENO");
            start = 100;                //skoč do menu
          }
          else  //pokud se neshodují
          {
            for(i=0; i<4; i++)  //vymaž zadaný kód
              {
                inKLAVESNICE[i] = 35;
              }
            digitalWrite(LEDc, HIGH);   //rozsviť LED čekej
            delay(3000);  //čekej 3s    //čekej penále 3s
            
            digitalWrite(LEDc, LOW);    //zhasni LED tlačítek
            digitalWrite(LED4, LOW);
            digitalWrite(LED3, LOW);  
            digitalWrite(LED2, LOW);  
            digitalWrite(LED1, LOW); 
          }

         
      
    }
}

////////////////////////////////ZAMKNI DVEŘE//////////////////////////////////////
void zamkni()
  {
   zamek.write(90);
  }

////////////////////////////////ODEMKNI DVEŘE//////////////////////////////////////
void odemkni()
  {
   zamek.write(0);
  }

