#include <DallasTemperature.h>
#include <OneWire.h>
#include <LiquidCrystal.h>

// Datová linka na pin 8
OneWire oneWire(8);

//LED dioda na pin 13
int led = 13;

//relé na pin 12
int rele = 12;

//rozdíl teplot při kterém sepne relé
int rozdil = 10;

// Promĕnné teplot
float Tbazen;
float Tpanel;

//Proměnná počítadla
int pocitadlo;

// Nastavení 1-wire
DallasTemperature sensors(&oneWire);

//Adresy čidel
DeviceAddress BAZEN = { 0x28, 0x1F, 0xBD, 0xCB, 0x04, 0x00, 0x00, 0xF1 };
DeviceAddress PANEL = { 0x28, 0x60, 0x67, 0xCE, 0x04, 0x00, 0x00, 0x2F };

//zapojení LCD - 7=RS; 6=Enable; 5=D4; 4=D5; 3=D6; 2=D7
LiquidCrystal lcd(7, 6, 5, 4, 3, 2);

//vytvoření znaku pro stupeň
byte degree[8] = {
	B00111,
	B00101,
	B00111,
  	B00000,
  	B00000,
	B00000,
	B00000,
	B00000
};

void setup(){

  //vypni čerpadlo
  digitalWrite(rele,HIGH);

  //nastavení typu LCD - 16 znaků, 2 řádky
  lcd.begin(16, 2);

  //vytvoření znaku pro stupeň
  lcd.createChar(0, degree);

  sensors.begin();
  //nastavení rozlišení čidel
  sensors.setResolution(BAZEN, 10);
  sensors.setResolution(PANEL, 10);


   pinMode(led, OUTPUT);
   pinMode(rele, OUTPUT);
  //demo
  lcd.setCursor(0, 0);
  lcd.print("Regulator bazenu");
  lcd.setCursor(0, 1);
  lcd.print("     v. 1.0     ");

  delay(2000);

  lcd.setCursor(0, 0);
  lcd.print("  www.arze.cz");

  delay(2000);
}

void loop(){ 

  sensors.requestTemperatures();

   //načtení teplot z čidel
   Tbazen = sensors.getTempC(BAZEN);  //teplota bazenu
   Tpanel = sensors.getTempC(PANEL);   //teplota panelu

   //smaž LCD
   lcd.clear();

   lcd.setCursor(0, 0);   //nastav první řádek
   lcd.print("Bazen:");
   lcd.print(Tbazen);     //teplota bazenu
   lcd.write((byte)0);
   lcd.print("C");


   lcd.setCursor(0, 1);   //nastav druhý řádek
   lcd.print("Panel:");
   lcd.print(Tpanel);     //teplota panelu
   lcd.write((byte)0);
   lcd.print("C");

if (Tbazen < 70 && Tbazen > 0 && Tpanel < 70 && Tpanel > 0)
{
 
 if (Tbazen >= Tpanel)  //pokud je teplota bazénu stejná nebo vĕtší než teplota panelu, pak
   {
   digitalWrite(rele, HIGH);  //vypni čerpadlo
   digitalWrite(led, LOW);   //zhasni diodu
   }

   Tbazen = Tbazen + rozdil;  //k teplotĕ bazénu přičti požadovaný rozdíl

 if (Tpanel >= Tbazen)   //pokud je teplota panelu vĕtší než teplota bazénu + rozdíl, pak
  {
  digitalWrite(rele, LOW);  //zapni čerpadlo
  digitalWrite(led, HIGH);   //roži diodu
  }
}

   pocitadlo++;

   delay(2000);  //čekej 2s

   if (pocitadlo == 150)  //pokud uběhlo 5 minut
    {
     pocitadlo = 0;      //vynuluj počítadlo
     lcd.begin(16, 2);   //resetuj LCD
     lcd.createChar(0, degree);
    }

}
