import serial
import time
import psutil

# Nastavíme sériový port - změň /dev/ttyUSB0 na správný port, pokud je jiný
ser = serial.Serial('/dev/ttyUSB0', 9600, timeout=1)  
time.sleep(2)  # Počkáme na inicializaci Arduina

while True:
    # Získáme vytížení CPU v %
    cpu_load = psutil.cpu_percent()

    # Získáme využití RAM v %
    ram_load = psutil.virtual_memory().percent  

    # Získáme teplotu CPU (pro RPi 4 použij 'cpu_thermal')
    try:
        temp = psutil.sensors_temperatures().get('cpu_thermal', [])[0].current
    except (KeyError, IndexError, TypeError):
        temp = "NEZNAMA"  # Pokud teplotu nelze načíst

    # Sestavíme datový řetězec: CPU%, RAM%, Teplota
    data = f"{cpu_load:.1f},{ram_load:.1f},{temp:.1f}\n"
    
    # Odešleme na Arduino
    ser.write(data.encode())
    
    # Počkáme 3 sekundy a opakujeme
    time.sleep(3)
