#include <Arduino.h>
#include <TM1637Display.h>

#define CLK 2   //clk pin displeje na pin 2
#define DIO 3   //dio pin displeje na pin 3
#define LED 4   //LED mínus na pin 4

float X = 0;    //proměnná přijaté hodnoty

uint8_t vypis[] = { 0, 0, 0, 0 };  //proměnná pro výpis na displej
 
TM1637Display displej(CLK, DIO);   //nastavení pinů pro displej

void setup() 
{
  Serial.begin(115200);      //start sériáku
  
  displej.setBrightness(10); //nastavení svítivosti LED displeje 8-15
  
  pinMode(LED, OUTPUT);      //LED mínus výstup
  digitalWrite(LED,LOW);     //LED mínus zhasnout
}

void loop()
{
  if(Serial.available()>1)      //pokud jsou přijata data
    {
      X = Serial.parseFloat();  //X = přijatá data
    
     //testování kladné či záporné teploty
     if (X < 0)
      {
        digitalWrite(LED,HIGH); //pokud je teplota nižší než 0 rozsviť mínus
      }
      else if (X > 0)
      {
        digitalWrite(LED,LOW); //jinak pokud je teplota vyšší než 0 zhasni LED
      }

     //odstanění desetiného místa a znaménka
     X = abs(X); //odstranění znaménka
     int Y = X * 100; //odstranění des. místa
    

     //rozepsání čísel na LCD
     if (Y >= 1000)
      {
       vypis[0] = displej.encodeDigit(Y / 1000);
       vypis[1] = displej.encodeDigit((Y % 1000)/100);
       vypis[2] = displej.encodeDigit(((Y % 1000)%100)/10);
       vypis[3] = displej.encodeDigit(((Y % 1000)%100)%10);
      }
      
     if (Y < 1000)
      {
       vypis[0] = 0; 
       vypis[1] = displej.encodeDigit(Y / 100);
       vypis[2] = displej.encodeDigit((Y % 100)/10);
       vypis[3] = displej.encodeDigit((Y % 100)%10);
      }

     if (Y < 100)
      {
       vypis[0] = 0; 
       vypis[1] = displej.encodeDigit(0);  
       vypis[2] = displej.encodeDigit(Y / 10);
       vypis[3] = displej.encodeDigit(Y % 10);
      }

      if (Y < 10)
      {
       vypis[0] = 0;
       vypis[1] = displej.encodeDigit(0); 
       vypis[2] = displej.encodeDigit(0);  
       vypis[3] = displej.encodeDigit(Y % 10);
      }

      displej.setSegments(vypis); //výpis na displej
  }
}
