#include <OneWire.h>
#include <DallasTemperature.h>
#include <ESP8266WiFi.h>

OneWire oneWire(0);                   //datová linka čidel

float Tbazen;   //teplota bazénu 
float Tvzduch;  //teplota vzduchu
int pocitadlo = 299;  //počítadlo smyček
int retries;

DallasTemperature sensors(&oneWire);  // Nastavení 1-wire

//Adresy čidel
DeviceAddress BAZEN =  { 0x28, 0xFF, 0x64, 0x1E, 0x5B, 0xB9, 0x47, 0xA4 };
DeviceAddress VZDUCH = { 0x28, 0xFF, 0x64, 0x1E, 0x5B, 0x85, 0x05, 0x3E };

String apiKlic = "xxxxxxxx";                          //thingspeak klíč
const char* server = "api.thingspeak.com";                    //adresa thingspeaku

const char* nazevWifi = "xxxx";
const char* hesloWifi = "xxxx";




WiFiClient client;

void setup()
{
  Serial.begin(9600);
  sensors.begin();

  sensors.setResolution(BAZEN, 10);   //nastavení rozlišení čidla
  sensors.setResolution(VZDUCH, 10);  //nastavení rozlišení čidla

  WiFi.persistent(false);
  WiFi.begin(nazevWifi, hesloWifi);  //nastavení WIFI
  

  while ((WiFi.status() != WL_CONNECTED) && (retries < 10)) 
   {
    retries++;
    delay(2000);
   }
}

void loop(){ 

  sensors.requestTemperatures();

   //načtení teplot z čidel
  Tbazen = sensors.getTempC(BAZEN);    //teplota bazénu
  Tvzduch = sensors.getTempC(VZDUCH);  //teplota vzduchu

  Serial.print("Teplota vzduchu: ");
  Serial.println(Tvzduch);
  Serial.print("Teplota bazénu: ");
  Serial.println(Tbazen);

  pocitadlo++;
  Serial.print("počítadlo: ");
  Serial.println(pocitadlo);
  delay(1000);  //čekej 1s

   if (pocitadlo == 300)  //pokud uběhlo 5 minut
    {
     pocitadlo = 0;      //vynuluj počítadlo
     Serial.println("odesílám na thingspeak");
    if (client.connect(server,80)) //odeslání na Thingspeak
      {
        // vytvoření zprávy, která bude odeslána na Thingspeak
        String zprava = apiKlic;
        zprava +="&field1=";
        zprava += String(Tbazen); //teplota bazénu
        zprava +="&field2=";
        zprava += String(Tvzduch); //teplota venku
        zprava += "\r\n\r\n";
        // po vytvoření celé zprávy ji odešleme na server Thingspeak
        // včetně našeho API klíče
        client.print("POST /update HTTP/1.1\n");
        client.print("Host: api.thingspeak.com\n");
        client.print("Connection: close\n");
        client.print("X-THINGSPEAKAPIKEY: "+apiKlic+"\n");
        client.print("Content-Type: application/x-www-form-urlencoded\n");
        client.print("Content-Length: ");
        client.print(zprava.length());
        client.print("\n\n");
        client.print(zprava);
        }
        delay(500);
        // ukončení spojení se serverem Thingspeak
        client.stop();
        Serial.println("odesláno");
    }
    

}
